<?php
$token = '7164488629:AAF5NQ-kngkY7f8LoY3wDUWzhDFWtRIb768';
$admins = [
    '99625832' => 'مدیر 1',
    '44419758' => 'مدیر 2'
];
$api_url = "https://api.telegram.org/bot$token/";
$db_file = 'active_chats_beta.json';

// Load active chats from file
$active_chats = file_exists($db_file) ? json_decode(file_get_contents($db_file), true) : [];

// Parse the incoming update
$content = file_get_contents("php://input");
$update = json_decode($content, true);
if (!$update) exit;

$message = $update['message'] ?? [];
$chat_id = $message['chat']['id'] ?? '';
$text = $message['text'] ?? '';
$message_id = $message['message_id'] ?? '';

// Function to send message
function sendMessage($chat_id, $text, $keyboard = null) {
    global $api_url;
    $data = [
        'chat_id' => $chat_id,
        'text' => $text
    ];
    if ($keyboard) {
        $data['reply_markup'] = json_encode($keyboard);
    }
    $options = [
        'http' => [
            'method'  => 'POST',
            'header'  => 'Content-type: application/x-www-form-urlencoded',
            'content' => http_build_query($data)
        ]
    ];
    $context  = stream_context_create($options);
    $result = file_get_contents($api_url . "sendMessage", false, $context);
    return $result;
}

// Function to send files
function sendFiles($chat_id, $files) {
    global $api_url;
    foreach ($files as $file) {
        $data = [
            'chat_id' => $chat_id,
            'document' => new CURLFile(realpath($file))
        ];
        $options = [
            'http' => [
                'method'  => 'POST',
                'content' => $data
            ]
        ];
        $context  = stream_context_create($options);
        $result = file_get_contents($api_url . "sendDocument", false, $context);
        return $result;
    }
}

// Function to forward message
function forwardMessage($to_chat_id, $from_chat_id, $message_id) {
    global $api_url;
    $data = [
        'chat_id' => $to_chat_id,
        'from_chat_id' => $from_chat_id,
        'message_id' => $message_id
    ];
    $options = [
        'http' => [
            'method'  => 'POST',
            'header'  => 'Content-type: application/x-www-form-urlencoded',
            'content' => http_build_query($data)
        ]
    ];
    $context  = stream_context_create($options);
    $result = file_get_contents($api_url . "forwardMessage", false, $context);
    return $result;
}

// Define links for purchase options
$purchase_links = [
    '25گیگ/یکماهه = 75 هزارتومان' => 'https://zarinp.al/596458',
    '50گیگ/یکماهه = 150 هزارتومان' => 'https://zarinp.al/596459',
    '75گیگ/یکماهه = 200 هزارتومان' => 'https://zarinp.al/596460'
];

// Handle incoming messages
if ($chat_id && !isset($admins[$chat_id])) {
    if (strpos($text, '/start') === 0) {
        $keyboard = [
            'keyboard' => [
                [['text' => 'مدیر 1'], ['text' => 'مدیر 2']]
            ],
            'one_time_keyboard' => true,
            'resize_keyboard' => true
        ];
        sendMessage($chat_id, "لطفا یکی از مدیران را انتخاب کنید:", $keyboard);
    } elseif (in_array($text, $admins)) {
        $selected_admin = array_search($text, $admins);
        $active_chats[$chat_id] = $selected_admin;
        file_put_contents($db_file, json_encode($active_chats));
        $keyboard = [
            'keyboard' => [
                [['text' => 'انتخاب مجدد مدیر']],
                [['text' => 'خرید'], ['text' => 'پشتیبانی']]
            ],
            'one_time_keyboard' => true,
            'resize_keyboard' => true
        ];
        sendMessage($chat_id, "شما مدیر {$text} را انتخاب کردید. حالا لطفا یکی از گزینه‌های زیر را انتخاب کنید:", $keyboard);
    } elseif ($text == 'انتخاب مجدد مدیر') {
        $keyboard = [
            'keyboard' => [
                [['text' => 'مدیر 1'], ['text' => 'مدیر 2']]
            ],
            'one_time_keyboard' => true,
            'resize_keyboard' => true
        ];
        sendMessage($chat_id, "لطفا یکی از مدیران را انتخاب کنید:", $keyboard);
    } elseif (isset($active_chats[$chat_id])) {
        if ($text == 'خرید') {
            $keyboard = [
                'keyboard' => [
                    [['text' => '25گیگ/یکماهه = 75 هزارتومان']],
                    [['text' => '50گیگ/یکماهه = 150 هزارتومان']],
                    [['text' => '75گیگ/یکماهه = 200 هزارتومان']],
                    [['text' => 'بازگشت']]
                ],
                'one_time_keyboard' => true,
                'resize_keyboard' => true
            ];
            sendMessage($chat_id, "لطفا یکی از گزینه‌های زیر را انتخاب کنید:", $keyboard);
        } elseif ($text == 'پشتیبانی') {
            sendMessage($chat_id, "لطفا سوال یا مشکل خود را در یک پیام نوشته و از ارسال پیام های متعدد تا قبل از پاسخگویی مدیر مربوطه خودداری فرمای
