<?php
$token = '7095827593:AAFRkcoa8XjqqoCJDzxVjJUEqU6LXT1SeEc'; // توکن ربات خود را قرار دهید
$admins = [
    '99625832' => 'مدیر 1',
    '44419758' => 'مدیر 2'
];
$api_url = "https://api.telegram.org/bot$token/";
$db_file = 'active_chats.json';

// بارگذاری چت‌های فعال از فایل
$active_chats = file_exists($db_file) ? json_decode(file_get_contents($db_file), true) : [];

// پردازش بروزرسانی دریافتی
$content = file_get_contents("php://input");
$update = json_decode($content, true);
if (!$update) exit;

$message = $update['message'] ?? [];
$chat_id = $message['chat']['id'] ?? '';
$text = $message['text'] ?? '';
$message_id = $message['message_id'] ?? '';
$from = $message['from'] ?? [];

// تابع ارسال درخواست با استفاده از POST
function sendRequest($method, $data) {
    global $api_url;
    $ch = curl_init($api_url . $method);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    if(curl_errno($ch)){
        error_log('Curl error: ' . curl_error($ch));
    }
    curl_close($ch);
    return $response;
}

// تابع ارسال پیام متنی با قابلیت HTML و کیبورد
function sendMessage($chat_id, $text, $keyboard = null) {
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML' // استفاده از HTML برای هایپرلینک‌ها
    ];
    if ($keyboard) {
        $data['reply_markup'] = json_encode($keyboard, JSON_UNESCAPED_UNICODE);
    }
    sendRequest("sendMessage", $data);
}

// تابع ارسال پیام به صورت فروروارد
function forwardMessage($chat_id, $from_chat_id, $message_id) {
    $data = [
        'chat_id' => $chat_id,
        'from_chat_id' => $from_chat_id,
        'message_id' => $message_id
    ];
    sendRequest("forwardMessage", $data);
}

// تابع کپی کردن پیام (برای انواع پیام‌ها)
function copyMessageToUser($from_chat_id, $message_id, $to_chat_id) {
    $data = [
        'chat_id' => $to_chat_id,
        'from_chat_id' => $from_chat_id,
        'message_id' => $message_id
    ];
    sendRequest("copyMessage", $data);
}

// تابع ارسال پیام به تمامی کاربران
function broadcastMessage($from_chat_id, $message_id) {
    global $active_chats;
    foreach ($active_chats as $user_id => $user_info) {
        copyMessageToUser($from_chat_id, $message_id, $user_id);
    }
}

// تابع تولید لیست کاربران به صورت هایپرلینک
function generateUserList($active_chats) {
    $user_list = "";
    foreach ($active_chats as $user_id => $user_info) {
        $first_name = htmlspecialchars($user_info['first_name'] ?? '', ENT_QUOTES);
        $last_name = htmlspecialchars($user_info['last_name'] ?? '', ENT_QUOTES);
        $username = $user_info['username'] ?? '';
        $full_name = trim("$first_name $last_name");
        $full_name = $full_name ? $full_name : "کاربر بدون نام";

        if ($username) {
            $link = "https://t.me/" . htmlspecialchars($username, ENT_QUOTES);
            $user_display = "<a href=\"$link\">$full_name</a>";
        } else {
            $link = "tg://user?id=$user_id";
            $user_display = "<a href=\"$link\">$full_name</a>";
        }

        $user_list .= "- $user_display\n";
    }
    return $user_list;
}

// تعریف لینک‌های گزینه‌های خرید
$purchase_links = [
    '30گیگ/یکماهه = 65 هزارتومان' => 'https://zarinp.al/596458',
    '40گیگ/یکماهه = 75 هزارتومان' => 'https://zarinp.al/615557',
    '50گیگ/یکماهه = 85 هزارتومان' => 'https://zarinp.al/596459',
    '80گیگ/یکماهه = 135 هزارتومان' => 'https://zarinp.al/673558',
    '100گیگ/یکماهه = 160 هزارتومان' => 'https://zarinp.al/678172',
    '30گیگ/دوماهه = 75 هزارتومان' => 'https://zarinp.al/683256',
    '40گیگ/دوماهه = 85 هزارتومان' => 'https://zarinp.al/683257',
    '50گیگ/دوماهه = 100 هزارتومان' => 'https://zarinp.al/683258',
    '80گیگ/دوماهه = 155 هزارتومان' => 'https://zarinp.al/683259',
    '100گیگ/دوماهه = 185 هزارتومان' => 'https://zarinp.al/683260'
];

// مدیریت پیام‌های دریافتی
if ($chat_id) {
    // بررسی اینکه آیا پیام از یک مدیر ارسال شده است
    if (isset($admins[$chat_id])) {
        // بررسی اینکه آیا پیام ریپلای نیست
        if (!isset($message['reply_to_message'])) {
            // ارسال پیام به تمامی کاربران
            broadcastMessage($chat_id, $message_id);

            // تولید لیست کاربران به صورت هایپرلینک
            $user_list = generateUserList($active_chats);

            // ساخت پیام تایید به مدیر با لیست کاربران
            $confirmation_message = "پیام شما به تمامی کاربران ارسال شد.\n\nلیست کاربران:\n$user_list";

            // ارسال پیام تایید به مدیر
            sendMessage($chat_id, $confirmation_message);
            exit;
        } else {
            // مدیریت پاسخ به کاربران
            $reply_to_message = $message['reply_to_message'] ?? [];
            $original_message = $reply_to_message['forward_from'] ?? [];
            $original_chat_id = $original_message['id'] ?? '';
            $reply_to_message_id = $reply_to_message['message_id'] ?? '';

            if ($original_chat_id) {
                if (isset($active_chats[$original_chat_id]) && $active_chats[$original_chat_id]['admin_id'] !== $chat_id) {
                    sendMessage($chat_id, "این کاربر در حال گفتگو با مدیر دیگری است.");
                } else {
                    // کپی کردن پیام مدیر به کاربر اصلی
                    copyMessageToUser($chat_id, $message_id, $original_chat_id);
                }
            }
            exit;
        }
    }

    // اگر ارسال‌کننده مدیر نیست
    if (!isset($admins[$chat_id])) {
        // ثبت یا به‌روزرسانی اطلاعات کاربر
        $user_first_name = htmlspecialchars($from['first_name'] ?? '', ENT_QUOTES);
        $user_last_name = htmlspecialchars($from['last_name'] ?? '', ENT_QUOTES);
        $user_username = $from['username'] ?? '';

        // اگر کاربر قبلاً ثبت شده است، اطلاعات او را به‌روزرسانی کنید
        if (array_key_exists($chat_id, $active_chats)) {
            $active_chats[$chat_id]['first_name'] = $user_first_name;
            $active_chats[$chat_id]['last_name'] = $user_last_name;
            $active_chats[$chat_id]['username'] = $user_username;
        } else {
            // اگر کاربر جدید است، اطلاعات او را ثبت کنید
            $active_chats[$chat_id] = [
                'admin_id' => null,
                'first_name' => $user_first_name,
                'last_name' => $user_last_name,
                'username' => $user_username
            ];
        }

        // ذخیره مجدد فایل با اطلاعات جدید
        file_put_contents($db_file, json_encode($active_chats, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));

        // پردازش دستورات کاربر
        if (strpos($text, '/start') === 0) {
            $keyboard = [
                'keyboard' => [
                    [['text' => 'مدیر 1'], ['text' => 'مدیر 2']]
                ],
                'resize_keyboard' => true,
                'one_time_keyboard' => true
            ];
            sendMessage($chat_id, "لطفا یکی از مدیران را انتخاب کنید:", $keyboard);
        } elseif (in_array($text, $admins)) {
            $selected_admin = array_search($text, $admins);
            $active_chats[$chat_id]['admin_id'] = $selected_admin;
            file_put_contents($db_file, json_encode($active_chats, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            $keyboard = [
                'keyboard' => [
                    [['text' => 'انتخاب مجدد مدیر']],
                    [['text' => 'خرید'], ['text' => 'پشتیبانی']]
                ],
                'resize_keyboard' => true,
                'one_time_keyboard' => true
            ];
            sendMessage($chat_id, "شما مدیر {$text} را انتخاب کردید. حالا لطفا یکی از گزینه‌های زیر را انتخاب کنید:", $keyboard);
        } elseif ($text == 'انتخاب مجدد مدیر') {
            $keyboard = [
                'keyboard' => [
                    [['text' => 'مدیر 1'], ['text' => 'مدیر 2']]
                ],
                'resize_keyboard' => true,
                'one_time_keyboard' => true
            ];
            sendMessage($chat_id, "لطفا یکی از مدیران را انتخاب کنید:", $keyboard);
        } elseif (isset($active_chats[$chat_id])) {
            if ($text == 'خرید') {
                $keyboard = [
                    'keyboard' => [
                        [['text' => '30گیگ/یکماهه = 65 هزارتومان']],
                        [['text' => '40گیگ/یکماهه = 75 هزارتومان']],
                        [['text' => '50گیگ/یکماهه = 85 هزارتومان']],
                        [['text' => '80گیگ/یکماهه = 135 هزارتومان']],
                        [['text' => '100گیگ/یکماهه = 160 هزارتومان']],
                        [['text' => '30گیگ/دوماهه = 75 هزارتومان']],
                        [['text' => '40گیگ/دوماهه = 85 هزارتومان']],
                        [['text' => '50گیگ/دوماهه = 100 هزارتومان']],
                        [['text' => '80گیگ/دوماهه = 155 هزارتومان']],
                        [['text' => '100گیگ/دوماهه = 185 هزارتومان']],
                        [['text' => 'بازگشت']]
                    ],
                    'resize_keyboard' => true,
                    'one_time_keyboard' => true
                ];
                sendMessage($chat_id, "لطفا یکی از گزینه‌های زیر را انتخاب کنید:", $keyboard);
            } elseif ($text == 'پشتیبانی') {
                sendMessage($chat_id, "لطفا سوال یا مشکل خود را در یک پیام نوشته و از ارسال پیام‌های متعدد تا قبل از پاسخگویی مدیر مربوطه خودداری فرمایید.");
            } elseif (array_key_exists($text, $purchase_links)) {
                $admin_id = $active_chats[$chat_id]['admin_id'];
                forwardMessage($admin_id, $chat_id, $message_id); // فروروارد کردن پیام کاربر به مدیر
                $link = $purchase_links[$text];
                sendMessage($chat_id, "لینک برای خرید: \n$link \nلطفا بعد از پرداخت اسکرین‌شات مربوطه را در همینجا بارگذاری نموده و تا پاسخ مدیر مربوطه شکیبا باشید.");
            } elseif ($text == 'بازگشت') {
                $keyboard = [
                    'keyboard' => [
                        [['text' => 'انتخاب مجدد مدیر']],
                        [['text' => 'خرید'], ['text' => 'پشتیبانی']]
                    ],
                    'resize_keyboard' => true,
                    'one_time_keyboard' => true
                ];
                sendMessage($chat_id, "به حالت قبلی بازگشتید. حالا لطفا یکی از گزینه‌های زیر را انتخاب کنید:", $keyboard);
            } else {
                forwardMessage($active_chats[$chat_id]['admin_id'], $chat_id, $message_id);
            }
        } else {
            sendMessage($chat_id, "لطفا یکی از مدیران را انتخاب کنید با ارسال /start.");
        }
    }
}
?>
