<?php

// توکن ربات تلگرام
$token = "7095827593:AAFRkcoa8XjqqoCJDzxVjJUEqU6LXT1SeEc";
$apiURL = "https://api.telegram.org/bot" . $token;

// بارگذاری داده‌های JSON از فایل
function loadData($filename) {
    $data = file_get_contents($filename);
    return json_decode($data, true);
}

// واکشی اطلاعات کاربر از تلگرام
function fetchUserData($chatId) {
    global $apiURL;
    
    // فراخوانی API تلگرام
    $response = file_get_contents($apiURL . "/getChat?chat_id=" . $chatId);
    $data = json_decode($response, true);

    if (isset($data['result'])) {
        return [
            'first_name' => $data['result']['first_name'] ?? '',
            'last_name' => $data['result']['last_name'] ?? '',
            'username' => $data['result']['username'] ?? ''
        ];
    }
    return null; // در صورت عدم موفقیت
}

// به‌روزرسانی اطلاعات کاربران
function updateUsers($data, $updates) {
    $notUpdated = [];
    
    foreach ($updates as $chatId => $userInfo) {
        if (isset($data[$chatId])) {
            // به‌روزرسانی اطلاعات کاربر
            $data[$chatId]['first_name'] = $userInfo['first_name'] ?? $data[$chatId]['first_name'];
            $data[$chatId]['last_name'] = $userInfo['last_name'] ?? $data[$chatId]['last_name'];
            $data[$chatId]['username'] = $userInfo['username'] ?? $data[$chatId]['username'];
        } else {
            // اگر chatId وجود ندارد، آن را به آرایه notUpdated اضافه کن
            $notUpdated[] = $chatId;
        }
    }
    
    return [$data, $notUpdated];
}

// بارگذاری داده‌ها از فایل
$data = loadData('active_chats.json');

// واکشی اطلاعات برای هر کاربر
$updates = [];
foreach ($data as $chatId => $userInfo) {
    $userData = fetchUserData($chatId);
    if ($userData) {
        $updates[$chatId] = $userData;
    }
}

// به‌روزرسانی اطلاعات برای تمام کاربران
list($updatedData, $notUpdated) = updateUsers($data, $updates);

// خروجی به‌صورت JSON
header('Content-Type: application/json');
$response = [
    "updated_data" => $updatedData,
    "not_updated" => $notUpdated
];

echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
