<?php

// ======================= تنظیمات اصلی =======================
// توکن ربات خود را که از BotFather دریافت کرده‌اید، اینجا وارد کنید
$token = '7095827593:AAFRkcoa8XjqqoCJDzxVjJUEqU6LXT1SeEc'; 

// شناسه‌ی عددی مدیران ربات را اینجا وارد کنید
// برای پیدا کردن شناسه‌ی عددی خود، به ربات @userinfobot پیام دهید
$admins = [
    '99625832' => 'مدیر اصلی',
    '44419758' => 'مدیر دوم'
    // می‌توانید مدیران بیشتری اضافه کنید
];

// اطلاعات کارت بانکی که برای کاربر نمایش داده می‌شود
$card_info = "6037-xxxx-xxxx-xxxx\nبانک ملیسامانبه نام فلانی"; 

// ======================= فایل‌های ذخیره‌سازی =======================
$api_url = "https://api.telegram.org/bot$token/";
$db_file_users = 'users_db.json';      // فایل برای ذخیره کاربران
$db_file_plans = 'plans_db.json';      // فایل برای ذخیره پلن‌ها و قیمت‌ها
$db_file_states = 'user_states.json';  // فایل برای ذخیره وضعیت کاربران (مثلا منتظر ارسال اسکرین‌شات)

// بارگذاری داده‌ها از فایل‌ها
$active_chats = file_exists($db_file_users) ? json_decode(file_get_contents($db_file_users), true) : [];
$plans = file_exists($db_file_plans) ? json_decode(file_get_contents($db_file_plans), true) : [];
$user_states = file_exists($db_file_states) ? json_decode(file_get_contents($db_file_states), true) : [];

// اگر فایل پلن‌ها خالی بود، یک نمونه اولیه ایجاد می‌کنیم تا ربات در اولین اجرا کار کند
if (empty($plans)) {
    $plans = [
        ['plan' => '30 گیگ / یکماهه', 'price' => '65,000 تومان'],
        ['plan' => '50 گیگ / یکماهه', 'price' => '85,000 تومان'],
        ['plan' => '100 گیگ / یکماهه', 'price' => '160,000 تومان'],
        ['plan' => '50 گیگ / دوماهه', 'price' => '100,000 تومان'],
    ];
    file_put_contents($db_file_plans, json_encode($plans, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
}

// ======================= پردازش آپدیت تلگرام =======================
$update = json_decode(file_get_contents("php://input"), true);
if (!$update) exit;

// تشخیص نوع آپدیت (پیام عادی یا کلیک روی دکمه)
$message = $update['message'] ?? null;
$callback_query = $update['callback_query'] ?? null;

if ($message) {
    $chat_id = $message['chat']['id'];
    $text = $message['text'] ?? '';
    $message_id = $message['message_id'];
    $from = $message['from'];
    $photo = $message['photo'] ?? null;
} elseif ($callback_query) {
    $chat_id = $callback_query['from']['id'];
    $text = $callback_query['data']; // داده‌ی دکمه فشرده شده
    $message_id = $callback_query['message']['message_id'];
    $from = $callback_query['from'];
    answerCallbackQuery($callback_query['id']); // پاسخ به کلیک برای حذف حالت لودینگ
} else {
    exit;
}

// ======================= توابع اصلی ربات =======================

function sendRequest($method, $data) {
    global $api_url;
    $ch = curl_init($api_url . $method);
    curl_setopt_array($ch, [
        CURLOPT_POST => 1,
        CURLOPT_POSTFIELDS => $data,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
    ]);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        error_log('cURL Error: ' . curl_error($ch));
    }
    curl_close($ch);
    return $response;
}

function sendMessage($chat_id, $text, $keyboard = null) {
    $data = ['chat_id' => $chat_id, 'text' => $text, 'parse_mode' => 'HTML'];
    if ($keyboard) {
        $data['reply_markup'] = json_encode($keyboard, JSON_UNESCAPED_UNICODE);
    }
    sendRequest("sendMessage", $data);
}

function forwardMessage($to_chat_id, $from_chat_id, $message_id) {
    sendRequest("forwardMessage", ['chat_id' => $to_chat_id, 'from_chat_id' => $from_chat_id, 'message_id' => $message_id]);
}

function answerCallbackQuery($callback_query_id, $text = '') {
    sendRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => $text]);
}

// تابع برای تغییر وضعیت کاربر
function setUserState($user_id, $state_data) {
    global $user_states, $db_file_states;
    $user_states[$user_id] = $state_data;
    file_put_contents($db_file_states, json_encode($user_states, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
}

// تابع برای گرفتن وضعیت کاربر
function getUserState($user_id) {
    global $user_states;
    return $user_states[$user_id] ?? null;
}

// تابع برای حذف وضعیت کاربر
function clearUserState($user_id) {
    global $user_states, $db_file_states;
    unset($user_states[$user_id]);
    file_put_contents($db_file_states, json_encode($user_states, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
}

// ======================= منطق ربات =======================

// بررسی اگر پیام از طرف ادمین است
if (isset($admins[$chat_id])) {
    // دستور به‌روزرسانی پلن‌ها
    if (strpos($text, '/update_plans') === 0) {
        $new_plans_text = trim(str_replace('/update_plans', '', $text));
        if (empty($new_plans_text)) {
            sendMessage($chat_id, "<b>خطا:</b> فرمت صحیح نیست.\nبرای ویرایش پلن‌ها، پیام را به این شکل ارسال کنید:\n\n<code>/update_plans\nپلن اول - قیمت اول\nپلن دوم - قیمت دوم\n...</code>\n\n<b>مثال:</b>\n<code>/update_plans\n30 گیگ / یکماهه - 65,000 تومان\n50 گیگ / یکماهه - 85,000 تومان</code>");
        } else {
            $lines = explode("\n", $new_plans_text);
            $new_plans = [];
            $error = false;
            foreach ($lines as $line) {
                if (strpos($line, ' - ') !== false) {
                    list($plan_name, $price) = explode(' - ', $line, 2);
                    $new_plans[] = ['plan' => trim($plan_name), 'price' => trim($price)];
                } else {
                    $error = true;
                    break;
                }
            }
            if ($error) {
                sendMessage($chat_id, "<b>خطا در فرمت:</b> هر خط باید شامل نام پلن و قیمت باشد که با ` - ` از هم جدا شده‌اند.");
            } else {
                global $plans, $db_file_plans;
                $plans = $new_plans;
                file_put_contents($db_file_plans, json_encode($plans, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
                sendMessage($chat_id, "✅ پلن‌ها با موفقیت به‌روزرسانی شدند.");
            }
        }
    } 
    // پاسخ به کاربر (ریپلای)
    elseif (isset($message['reply_to_message'])) {
        $reply_to_message = $message['reply_to_message'];
        $user_to_reply_id = null;

        // Check if it's a reply to a forwarded message
        if (isset($reply_to_message['forward_from'])) {
            $user_to_reply_id = $reply_to_message['forward_from']['id'];
        } 
        // Check if it's a reply to a photo with a caption that contains user info
        elseif (isset($reply_to_message['caption']) && preg_match('/tg:\/\/user\?id=(\d+)/', $reply_to_message['caption'], $matches)) {
            $user_to_reply_id = $matches[1];
        }

        if ($user_to_reply_id) {
            sendRequest("copyMessage", [
                'chat_id' => $user_to_reply_id,
                'from_chat_id' => $chat_id,
                'message_id' => $message_id
            ]);
            sendMessage($chat_id, "✅ پاسخ شما برای کاربر ارسال شد.");
        } else {
            sendMessage($chat_id, "خطا: امکان ارسال پاسخ وجود ندارد. لطفاً فقط به پیام‌های فوروارد شده از کاربران پاسخ دهید.");
        }
    } 
    // پیام عادی ادمین (راهنما)
    else {
        sendMessage($chat_id, "سلام مدیر گرامی!\n\n🔹 برای ویرایش پلن‌ها از دستور /update_plans استفاده کنید.\n🔹 برای پاسخ به کاربران، روی پیام فوروارد شده از آن‌ها ریپلای کنید.");
    }
    exit;
}

// منطق برای کاربران عادی
if (!isset($admins[$chat_id])) {
    // ذخیره اطلاعات کاربر
    if (!isset($active_chats[$chat_id])) {
        $active_chats[$chat_id] = [
            'first_name' => $from['first_name'] ?? '',
            'last_name' => $from['last_name'] ?? '',
            'username' => $from['username'] ?? ''
        ];
        file_put_contents($db_file_users, json_encode($active_chats, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    }

    // بررسی وضعیت کاربر (آیا منتظر ارسال اسکرین‌شات است؟)
    $current_state = getUserState($chat_id);
    if ($photo && $current_state && $current_state['action'] === 'awaiting_screenshot') {
        $selected_plan = $current_state['plan'];
        $selected_price = $current_state['price'];
        $user_info = $active_chats[$chat_id];
        $user_link = $user_info['username'] ? "@" . $user_info['username'] : "<a href='tg://user?id={$chat_id}'>" . htmlspecialchars($user_info['first_name']) . "</a>";
        
        $caption = " رسید جدید دریافت شد \n\n"
                 . "<b>کاربر:</b> " . $user_link . "\n"
                 . "<b>پلن انتخابی:</b> " . htmlspecialchars($selected_plan) . "\n"
                 . "<b>مبلغ:</b> " . htmlspecialchars($selected_price);

        // ارسال اسکرین‌شات به تمام ادمین‌ها
        foreach (array_keys($admins) as $admin_id) {
            sendRequest("sendPhoto", [
                'chat_id' => $admin_id,
                'photo' => $photo[count($photo) - 1]['file_id'], // ارسال بهترین کیفیت عکس
                'caption' => $caption,
                'parse_mode' => 'HTML'
            ]);
        }
        
        sendMessage($chat_id, "✅ اسکرین‌شات شما با موفقیت برای مدیران ارسال شد.\n\nلطفاً تا زمان بررسی و پاسخگویی شکیبا باشید. به محض تایید، لینک یا فایل کانفیگ برای شما ارسال خواهد شد.");
        clearUserState($chat_id); // پاک کردن وضعیت کاربر
        exit;
    }

    switch ($text) {
        case '/start':
        case 'back_to_main':
            clearUserState($chat_id); // Clear any previous state
            $keyboard = [
                'inline_keyboard' => [
                    [['text' => '🛒 خرید سرویس', 'callback_data' => 'buy_service']],
                    [['text' => '📞 پشتیبانی', 'callback_data' => 'support']]
                ]
            ];
            sendMessage($chat_id, "سلام! به ربات فروش ما خوش آمدید.\n\nلطفاً یکی از گزینه‌های زیر را انتخاب کنید:", $keyboard);
            break;

        case 'buy_service':
            global $plans;
            $keyboard_buttons = [];
            foreach ($plans as $index => $plan_data) {
                $button_text = $plan_data['plan'] . " - " . $plan_data['price'];
                $keyboard_buttons[] = [['text' => $button_text, 'callback_data' => 'select_plan_' . $index]];
            }
            $keyboard_buttons[] = [['text' => '➡️ بازگشت', 'callback_data' => 'back_to_main']];
            
            $keyboard = ['inline_keyboard' => $keyboard_buttons];
            sendMessage($chat_id, "لطفاً سرویس مورد نظر خود را انتخاب کنید:", $keyboard);
            break;

        case 'support':
            sendMessage($chat_id, "لطفاً سوال یا مشکل خود را در یک پیام برای ما ارسال کنید تا به مدیران پشتیبانی منتقل شود.\n\n(از ارسال پیام‌های متعدد خودداری فرمایید)");
            break;
            
        default:
            // اگر کاربر در حال انتخاب پلن است
            if (strpos($text, 'select_plan_') === 0) {
                global $plans, $card_info;
                $plan_index = (int) str_replace('select_plan_', '', $text);
                
                if (isset($plans[$plan_index])) {
                    $selected_plan = $plans[$plan_index];
                    $plan_name = $selected_plan['plan'];
                    $price = $selected_plan['price'];
                    
                    $message_text = "شما پلن زیر را انتخاب کرده‌اید:\n"
                                  . "<b>" . htmlspecialchars($plan_name) . "</b>\n\n"
                                  . "مبلغ قابل پرداخت: <b>" . htmlspecialchars($price) . "</b>\n\n"
                                  . "لطفاً مبلغ را به شماره کارت زیر واریز کرده و سپس اسکرین‌شات (رسید) پرداخت را در همین صفحه ارسال نمایید.\n\n"
                                  . "<code>" . htmlspecialchars($card_info) . "</code>";

                    sendMessage($chat_id, $message_text);
                    // قرار دادن کاربر در وضعیت "منتظر اسکرین‌شات"
                    setUserState($chat_id, ['action' => 'awaiting_screenshot', 'plan' => $plan_name, 'price' => $price]);

                } else {
                    sendMessage($chat_id, "خطا: پلن انتخاب شده معتبر نیست. لطفاً دوباره تلاش کنید.");
                }
            } 
            // اگر پیام عادی است (برای پشتیبانی)
            else {
                // فوروارد پیام به تمام ادمین‌ها
                foreach (array_keys($admins) as $admin_id) {
                    forwardMessage($admin_id, $chat_id, $message_id);
                }
                sendMessage($chat_id, "پیام شما برای مدیران ارسال شد. لطفاً منتظر پاسخ بمانید.");
            }
            break;
    }
}
?>
